#include <bits/stdc++.h>
using namespace std;

using ll = long long;
const ll INF = (ll)4e18;

struct Mast {
    ll x, h;
    int id;
};

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<Mast> a(n);
    for(int i = 0; i < n; i++) cin >> a[i].x;
    for(int i = 0; i < n; i++) cin >> a[i].h, a[i].id = i;

    sort(a.begin(), a.end(), [](auto &p, auto &q){
        return p.x < q.x;
    });

    vector<ll> ans(n, INF);

    // -------- nearest higher mast to the left --------
    stack<int> st;
    for(int i = 0; i < n; i++){
        while(!st.empty() && a[st.top()].h < a[i].h) st.pop();
        if(!st.empty()){
            ll dx = a[i].x - a[st.top()].x;
            ll dy = a[st.top()].h - a[i].h;
            ans[a[i].id] = min(ans[a[i].id], dx*dx + dy*dy);
        }
        st.push(i);
    }

    // -------- nearest higher mast to the right --------
    while(!st.empty()) st.pop();
    for(int i = n-1; i >= 0; i--){
        while(!st.empty() && a[st.top()].h < a[i].h) st.pop();
        if(!st.empty()){
            ll dx = a[st.top()].x - a[i].x;
            ll dy = a[st.top()].h - a[i].h;
            ans[a[i].id] = min(ans[a[i].id], dx*dx + dy*dy);
        }
        st.push(i);
    }

    // -------- contribution from ropes --------
    for(int i = 0; i+1 < n; i++){
        ll x1 = a[i].x, h1 = a[i].h;
        ll x2 = a[i+1].x, h2 = a[i+1].h;

        ll midx = (x1 + x2 + h1 - h2) / 2;
        ll maxh = (h1 + h2 + (x2 - x1)) / 2;

        for(int k : {i, i+1}){
            if(maxh >= a[k].h){
                ll y = a[k].h;
                ll px;
                if(y >= h1)
                    px = x1 + (h1 - y);
                else
                    px = x2 - (h2 - y);

                ll dx = a[k].x - px;
                ans[a[k].id] = min(ans[a[k].id], dx*dx);
            }
        }
    }

    // -------- output --------
    for(int i = 0; i < n; i++){
        if(ans[i] == INF) cout << -1 << "\n";
        else cout << (ll) sqrt((long double)ans[i]) << "\n";
    }
}